#pragma once
#include <ATcrt/ATsystem.h>
#include <ATcrt/ATmem.h>
#include "Handler.h"
#include "Aerotri_defs.h"
#include "resultado_parcial.h"

/* Este programa tiene que reescribirse completamente. Estaba pensado para medidas manuales. El paradigma era eliminar
los mínimos puntos posible, y en caso de error indicar al usuario (y a la función que llama) cuáles son los posibles puntos
malos, para que se corrigiesen. Ahora, con datos de correladores automáticos, es exactamente al revés.
Especialmente urgente es el cambio de la función fotfot(). La función que se prgramó era rapidísima, tal vez la mejor
en su día para la orientación relativa en caso de fotografías no convergentes. Tiene, además de esta última restricción, lo
dicho en el párrafo anterior. Se fueron añadiendo parches pero es insuficiente; hay que programarlo de nuevo.
*/

typedef struct{
 uint8m usa_gps;	//0: no; 1: sí (de momento se trata igual que 2); 2: Emplear sólo si están todos
 bool8 force_mmcc;		//0: fuerza un ajuste mm.cc., !=0: deja que el programa ajuste como quiera
 u16int hacha;
 u16int maximof;	//máximo número de fotos para el ajuste riguroso de todo el modelo
 u16int mult_contra;	// =100*el valor
} ValoresAproximados;

typedef struct{
 uint elem_r;	//n de modelo resultado
 uint elem1;	//Si <0 es ~fotograma, si>0 un modelo.
 uint elem2;
 uint npuntos; //número de puntos en común
 uint ncentros; //número de fotos del modelo resultado
 Resultado ajuste;
} UnPaso;

typedef struct{
	uint najuste;	//Número de este ajuste dentro del proceso
	Resultado ajuste;
	uint nast;		//Número de asteriscos asignados al p_peor de este ajuste
} Ajuste_con_PuntoMalo;

/*En esta estructura ajustesmalos son todos los ajustes malos del proceso. paresmalos son hasta nueve pares de fotos
malos que el programa ha buscado basándose en los ajustes malos. Si hay más de nueve pares malos se almacenan
sólo los nueve peores. Como son pares de fotos los números elem1 y elem2 serán siempre <0, ncentros será 2 y el
número elem_r es irrelevante. En ambos caso ->ajuste.p_peor es el punto peor del ajuste.
*/
typedef struct{
	PLIST plist;	//Internal. Use only for the call free_plist()
	UnPaso paresmalos[10];	//.ajuste.vv==0 indica que ya se han acabado. Por ello el décimo se deja siempre a 0
	Ajuste_con_PuntoMalo* ajustesmalos;	//.najuste==EOUIA indica el final
	char8_t* nombresf;	//Puntero a una cadena con los nombres de las fotos, uno a continuación de otro
	char8_t* nombresp;	//Puntero a una cadena con los nombres de los puntos, uno a continuación de otro
	uint* fotos; //Para cada k, nombesf+fotos[k] es el puntero al nombre de la foto k.
	uint* puntos; //Para cada k, nombesp+puntos[k] es el puntero al nombre del punto k.
} InfoMalos;

/*
hwnd_main:		Puntero a una ventana de Windows para enviar mensajes de progreso. Si se pasa NULL se ignora
log_code:			El código de mensaje para los mensajes de progreso que se envíen. El texto es un char16_t* en lParam
log_level:			Información que se escribe en el fichero .pro más allá de la que siempre se escribe. Normalmente
							no es de interés (indica que se está leyendo o escribiendo tal o cuál fichero y poco más). 0,1 o 2
modo_toma:			v. Aerotri_defs
modo_medida:		v. Aerotri_defs
fichero:		nombre del fichero de fotogramas. Los de Aerotri suelen tener extensión .ftm
mar:			formato del fichero de fotogramas. 1= Formato de Aerotri, con marcas.
ficheroins:	fichero de orientación interna (necesario si las coordenadas del fichero de fotogramas están en píxeles o sin refinar).
					Si el fichero "fichero" ya contiene coordenadas respecto al punto principal y sin distorsión, pasar NULL aquí
inm:			formato del fichero de interna. De momento sólo se reconoce 0=Aerotri. Si ficheroins==NULL se ignora
ficherogps:	Fichero con datos gps e inerciales. Solamente se emplean si hay datos gps e ins para todos los fotogramas. Si los datos no
					tienen precisión suficiente suele ser mejor no emplear este fichero. Si no existe este fichero se debe pasar NULL.
gpm:			Ver el fichero lecturaf.h
signoins:		Sólo para los archivos de Aerotri
tdgps:			No estoy seguro de que se emplee. Pasar 1 si los datos son buenos, 2 si no son muy fiables
tdins:			Idem. Pasar 0 si los datos son buenos, 1 si no son muy fiables.
vmin:			Parámetro importante. Es la precisión de las fotocoordenadas. Suele ser 1/3 del tamaño del píxel. Si se pasa un valor demasiado alto,
					por ejemplo 10 veces más alto, el cálculo puede salir mal. Si el fichero de fotogramas está en píxeles, este valor estará entre
					0.25 y 0.5, siendo lo más común 0.3-0.35.
param:		Una estructura con opciones para el cálculo. Rellenar todo a 0 (e.g., con memset(&param,sizeof(ValoresAproximados)), excepto que
					usa_gps se pone a 2.
uni:			Unidades de los giros. Pasar 2 (grados sexagesimales).
pinfomalos:	Puntero a una estructura con información acerca de pares de fotos y puntos malos, que se rellena cuando se devuelve 10 o 11.
					Posteriormente es necesario liberar la memoria. Para ello hay que llamar a free_plist(pinfomalos->plist);
					Si no se quiere esta información se puede pasar NULL.
mensaje:		Pasar un char16_t[512]. Si el valor devuelo es -1 mensaje puede contener cualquier cosa, así que en estos casos no se debe mostrar.
idioma:		Idioma para el mensaje de error. 0=español, 1=inglés, 2=italiano.

return:	Además de los valores enumerados a continuación, la función puede devolver:
			-1 (AT_ESC): El usuario ha pulsado la tecla esc
			-2 (AT_NOMEM): Memoria insuficiente.
*/
enum ATCalculaRelativaCodes{
	ATmainrelativa_OK=0,
	ATmainrelativa_pro_noopen=1,	//No se puede abrir el fichero de proceso
	ATmainrelativa_error_ficherof,		//Error en la lectura del fichero de fotogramas
	ATmainrelativa_unafoto,				//No hay ninguna foto o solamente una (con al menos tres puntos medidos)
	ATmainrelativa_repetido,			//Hay una foto repetida / hay una foto con un punto repetido
	ATmainrelativa_fewpoints,			//No hay ningún par de fotos con al menos 5 puntos en común
	ATmainrelativa_error_camara,		//Error en la lectura del fichero de cámara

	ATmainrelativa_partialerror,		//Algún ajuste llegó a dar error
	ATmainrelativa_error_ajuste,		//Error en el ajuste (>10000*vmin)
	ATmainrelativa_manyblocks,		//No es posible unir todos los fotogramas en un único bloque

	ATmainrelativa_minorerr_write=101 //Error en la escritura del fichero de valores aproximados
};

#ifdef __cplusplus
extern "C"
#endif
int OUTSIDE_CALL mainrelativa(Handler hwnd_main,int log_code, u16int log_level, u8int modo_toma, u8int modo_medida,
											const char16_t* fichero,u8int mar, const char16_t* ficheroint,u8int inm,
											const char16_t* ficherogps,u8int gpm,bint signoins, u8int tdgps, u8int tdins, u8int bgeograficas,  //0: no-geog; 1: long-lat; 2: lat-long
											float vmin, ValoresAproximados param, s8int uni, InfoMalos *pinfomalos, char16_t* mensaje, u8int idioma);
